<?php

// Create url for given path
function url_for($script_path) {
    // add the leading '/' if not present
    if($script_path[0] != '/') {
        $script_path = "/" . $script_path;
    }
    
    return WWW_ROOT . $script_path;
}

// url encode
function u($string="") {
    return urlencode($string);
}

// raw url encode
function raw_u($string="") {
    return rawurlencode($string);
}

// html special character encoding
function h($string="") {
    return htmlspecialchars($string);
}

// 404 Error Header
function error_404() {
    header($_SERVER["SERVER_PROTOCOL"] . "404 Not Found");
    exit;
}

// 500 Error Header
function error_500 () {
    header($_SERVER["SERVER_PROTOCOL"] . "500 Internal Server Error");
    exit;
}

// redirect page
function redirect_to($location) {
    header("Location: " . $location);
    exit;
}

// check for POST request
function is_post_request() {
    return $_SERVER['REQUEST_METHOD'] == 'POST';
}

// check for GET request
function is_get_request() {
    return $_SERVER['REQUEST_METHOD'] == 'GET';
}

// display errors
function display_errors($errors=array()) {
    $output = '';
        if(!empty($errors)) {
            $output .= "<div class=\"errors\">";
            $output .= "Please fix the following errors:";
            $output .= "<ul>";
            foreach($errors as $error) {
                $output .= "<li>" . h($error) . "</li>";
            }
            $output .= "</ul>";
            $output .= "</div>";
        }
    return $output;
}

// get and clear session message
function get_and_clear_session_message() {
    if(isset($_SESSION['message']) && $_SESSION['message'] != '') {
        $msg = $_SESSION['message'];
        unset($_SESSION['message']);
        return $msg;
    }
}

// display session message
function display_session_message() {
    $msg = get_and_clear_session_message();
    
    if(!is_blank($msg)) {
        return '<div id="message">' . h($msg) . '</div>';
    }
}
?>
